import math

def read_input():
    return map(int, input().split())

def get_min_max(array):
    return min(array), max(array)

def sort_array(array):
    array.sort(key=int)

def calculate_power(array):
    minimum, maximum = get_min_max(array)
    return maximum ** 2 - minimum ** 2

def remove_element(array):

    left_array = array[0:len(array) - 1]
    right_array = array[1:len(array)]

    left_power = calculate_power(left_array)
    right_power = calculate_power(right_array)

    if left_power < right_power:
        del array[len(array) - 1]
    else:
        del array[0]


def bring_the_action(array, n, k):

    sort_array(array)

    for i in range(k):
        remove_element(array)

def main():

    n, k = read_input()
    array = list(map(int, input().split()))

    bring_the_action(array, n, k)

    print(calculate_power(array))

if __name__ == '__main__':
    main()